define([
    'backbone',
    'Layout',
    'modules/appointments/requested/requested-appointments-view',
], function(Backbone, Layout, RequestedAppointmentsView) {
    'use strict';

    describe('Requested Appointments View', function() {
        var view;
        var $view;
        var layout = new Layout();

        layout.render();

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            view = new RequestedAppointmentsView({ collection: new Backbone.Collection() });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        // afterAll(function() {
        //  layout.getRegion('content').empty();
        // });

        it('has a header', function() {
            expect($view.find('h3').text()).toEqual('Requests');
        });

        it('has a region to show requests', function() {
            expect($view.has(view.regions.appointmentsListRegion).length).toEqual(1);
        });
    });
});
